package gov.va.med.mhv.eauth;

import gov.va.med.mhv.eauth.service.delegate.EAuthHashServiceDelegate;
import gov.va.med.mhv.eauth.service.delegate.ServiceDelegateFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.service.StringServiceResponse;

import com.bea.p13n.util.encoding.EncodingUtil;

public class SplashScreenServlet extends HttpServlet implements EauthConstants {
	private static final long serialVersionUID = 5589615804128963698L;

	private static final String NOT_FOUND = "NOT_FOUND";
	
	private String splash_url;

	private String error_url;

	private String anonymous_url;

	private String eauth_portal;

	private String dslogon_value;

	private String usaa_value;

	private String va_eauth_assur_prop_level;

	Log clog = LogFactory.getFactory().getInstance(SplashScreenServlet.class);

	public void init(ServletConfig config) throws ServletException {
		super.init(config);

		Properties props = new Properties();
		String propertyFile = "eauth.properties";
		String path = System.getProperty("config.location");

		try {
			props.load(new FileInputStream(path + File.separator + propertyFile));
			eauth_portal = props.getProperty("eauth.portal.url");
			splash_url = props.getProperty("eauth.splash.screen.url");
			error_url = props.getProperty("eauth.error.url");
			anonymous_url = props.getProperty("eauth.anonymous.url", "/anonymous.portal");
			dslogon_value = props.getProperty("eauth.dslogon.value", "DSLOGON");
			usaa_value = props.getProperty("eauth.usaa.value", "USAA");
			va_eauth_assur_prop_level = props.getProperty("eauth.va.assurance.level", "2");
		} catch (IOException io) {
			clog.error("error getting properties", io);
		}
	}

	private boolean isDigit(String number) {
		if(number.equalsIgnoreCase("NOT_FOUND")) {
			return false;
		}
		
		char[] numberArray = number.toCharArray();
		for (int i = 0; i < numberArray.length; i++) {
			if(!Character.isDigit(numberArray[i])) {
				return false;
			}
		}
		return true;
	}

	/**
	 * JAZZ # 39187: Story:Remote ID Proofing - Implementation - 
	 * US REQ#1.2 In the event VAAFI sends NOT_FOUND value for any of the user traits in header 
	 * (first name, middle name, last name, birth date, ssn or gender), MHV system shall display 
	 * a user friendly message Not able to recognize account information sent to My HealtheVet 
	 * as a third bullet on the We Cannot Connect Your Account page.
	 * 
	 * @param dateStr
	 * @return
	 */
	private boolean isNotFound(String str) {
		if(str.equalsIgnoreCase(NOT_FOUND)) {
			return true;
		}
		return false;
	}
	
	private boolean isDate(String dateStr) {
		if(dateStr.equalsIgnoreCase(NOT_FOUND)) {
			return false;
		}
		
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date date = null;
		try {
			date = sdf.parse(dateStr.substring(0, 10));
		} catch (ParseException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	
	private boolean isEauthHashValid(String ahash) {
		if((ahash!=null) && !isNotFound(ahash) && ahash.length()==28 && ahash.endsWith("=")){
			return true;
		}
		return false;
	}
	
	private String findUserNameByHash(String ahash) {
		EAuthHashServiceDelegate esd = ServiceDelegateFactory.createEAuthHashServiceDelegate();
		StringServiceResponse ssr = esd.findUserNameByHash(ahash);
		return ssr.getString();
	}
	
	protected void doGet(HttpServletRequest req, HttpServletResponse res)
			throws ServletException, IOException {

		String error = null;
		boolean hasError = false;

		// need to validate request & make sure parameters are on request
		String ahash = req.getHeader(HASH_PARAM);
		String csid = req.getHeader(CSID_PARAM);
		String va_eauth_assurancelevel = req.getHeader(VA_EAUTH_ASSUR_LEVEL);
//		String deepLink = req.getHeader(DEEP_LINK);
		String deepLink = req.getParameter("deeplinking");

		if( clog.isDebugEnabled() ) {
			clog.debug("hash from request: " + ahash);
			clog.debug("the csid is: " + csid);
		}

		boolean ahashAlreadyValid = false;
		if(findUserNameByHash(ahash)!=null) {
			ahashAlreadyValid = true;
		} else {
			if(ahash.length()>28) {
				ahash = EncodingUtil.decodeXSS(ahash);
			}
		}
		
		if (ahashAlreadyValid || isEauthHashValid(ahash)) {
			//DEFECT: ahash = URLDecoder.decode(ahash, "UTF-8");
			csid = URLDecoder.decode(csid, "UTF-8");
			va_eauth_assurancelevel = URLDecoder.decode(va_eauth_assurancelevel, "UTF-8");
			// place in user session
			req.getSession(true).setAttribute(HASH_ATTR, ahash);
			req.getSession().setAttribute(CSID_ATTR, csid);
			req.getSession().setAttribute(LOGIN_TYPE, EAUTH);
			req.getSession().setAttribute(VA_EAUTH_ASSUR_LEVEL, va_eauth_assurancelevel);
			if(deepLink != null)
				req.getSession().setAttribute(DEEP_LINK_ATTR, URLDecoder.decode(deepLink, "UTF-8"));

			//if (csid.equalsIgnoreCase(dslogon_value)) {
			if(Integer.parseInt(va_eauth_assurancelevel) >= Integer.parseInt(va_eauth_assur_prop_level)) {
				/*
				 * CR 1010: Add additional fields to the session
				 */
				String firstName = req.getHeader(FIRST_NAME);
				String middleName = req.getHeader(MIDDLE_NAME);
				String lastName = req.getHeader(LAST_NAME);
				String birthDate = req.getHeader(BIRTH_DATE);
				String gender = req.getHeader(GENDER);
				String id = req.getHeader(ID);
				String edipiValue = req.getHeader(EDIPI_PARAM);

				if(clog.isDebugEnabled()) {
					clog.debug("RECEIVED THE FOLLOWING USER: " +"firstName:"+firstName	+" middleName:" +middleName +" lastName:"+lastName
							+" birthDate:" +birthDate +" id:" +"id" + " edipiValue:" + edipiValue
							+" csid:" +csid +" va_eauth_assurancelevel:" +va_eauth_assurancelevel);
				}

				if (null == firstName || null == lastName || null == birthDate
						|| null == id || null == edipiValue || null == va_eauth_assurancelevel) {
					// Check required fields
					clog.error("Missing required attributes in the header from VAAFI for DSLOGON");
					res.sendRedirect(anonymous_url);
					return;
				}
				
				if(null == gender) {
					gender = "";
				}

				firstName = URLDecoder.decode(firstName, "UTF-8");
				if(middleName != null) {
					middleName = URLDecoder.decode(middleName, "UTF-8");
					req.getSession().setAttribute(MIDDLE_NAME, middleName.toUpperCase());
				}
				lastName = URLDecoder.decode(lastName, "UTF-8");
				birthDate = URLDecoder.decode(birthDate, "UTF-8");
				gender = URLDecoder.decode(gender, "UTF-8");
				id = URLDecoder.decode(id, "UTF-8");
				edipiValue = URLDecoder.decode(edipiValue, "UTF-8");
				req.getSession().setAttribute(FIRST_NAME, firstName.toUpperCase());
				req.getSession().setAttribute(LAST_NAME, lastName.toUpperCase());
				req.getSession().setAttribute(BIRTH_DATE, birthDate);
				req.getSession().setAttribute(GENDER, gender.toUpperCase());
				req.getSession().setAttribute(ID, id);
				req.getSession().setAttribute(EDIPI_PARAM, edipiValue);
			}
		} else {
			if( clog.isDebugEnabled() ) {
				clog.debug("****************************** SplashScreenServlet() ahash error:" + ahash);
			}

			hasError = true;
			clog.error("Missing required attributes in the header from VAAFI");
		}
		if( clog.isDebugEnabled() ) {
			clog.debug("va_eauth_hash value: '" + ahash + "'");
		}

		String forward = splash_url;
		if (hasError) {
//			SplashScreenServlet.setNoCache(res);
//			RequestDispatcher rd = req.getRequestDispatcher(error_url);
//			rd.forward(req, res);
			res.sendRedirect("gateway");
			return;
		}else if(csid.equalsIgnoreCase("2030004")){
			// Retire ORC Logon. Redirect to custom page.
			res.sendRedirect(anonymous_url);
//		}else if(csid.equalsIgnoreCase("CAC")) {
//			res.sendRedirect(anonymous_url);
		}else if(Integer.parseInt(va_eauth_assurancelevel) < Integer.parseInt(va_eauth_assur_prop_level)) {
			res.sendRedirect(anonymous_url);
		}
		else {
			SplashScreenServlet.setNoCache(res);
			// Skip splash screen for already mapped users
			res.sendRedirect(skipSplashScreenForMappedUsers(ahash, csid));
		}
	}

	private static void setNoCache(HttpServletResponse response) {
		response.setHeader("Cache-Control", "no-cache");
		response.setHeader("Pragma", "no-cache");
		response.setDateHeader("Expires", 0);
	}

	protected long getLastModified(HttpServletRequest req) {
		return new Date().getTime();
	}

	public String skipSplashScreenForMappedUsers(String ahash, String csid) {
		// lookup userid in database
		String id = findUserNameByHash(ahash);
		if(clog.isDebugEnabled()){
			clog.debug("User found for hash of " + ahash + ", userid = " + id);
		}

		if (null != id) {
			return ("gateway");
		} else {
			if( clog.isDebugEnabled() ) {
				clog.debug("******************** SplashScreenServlet no hash going to the splash page");
			}
			return (splash_url);
		}
	}

	
	public static void main(String[] args) {
		String hash = "DSFCrSN3VJ5tjGdVvVHg05&#43;qlI0=";
		try {
//			String newHash = hash.replaceAll("&#43;","+");
//			String newHash = URLDecoder.decode(hash, "UTF-8");
//			String newHash = StringEscapeUtils.unescapeHtml(hash);
			String newHash = EncodingUtil.decodeXSS(hash);
			
			System.out.println(hash);
			System.out.println(hash.length());
			System.out.println(newHash);
			System.out.println(newHash.length());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
